<?php
/*****************************/
/** Theme's current version **/
/*****************************/
$theme_ver = "0.1.2";
/*****************************/
?>
<style>
	.widesec {width: auto;}
	.ra-settings {
	padding-left: 8px;
    padding-right: 20px;
	}
	.container-collapsed {
    margin-bottom: 20px;
	padding: 5px;
	}
	.component-settings, .expand-settings {
    display: none;
    padding: 5px;
	}
	.inner-divs label {
    display: inline-block;
    padding-right: 10px;
    margin-top: 4px;
	}
	.collapsedlegend {
    cursor: pointer;
    background-image: url("../admin/template/images/utick.png");
    background-repeat: no-repeat;
    background-position: 92% center;
    padding: 0px 18px 0px 8px;
    margin: 6px;
	}
	.theme-version {
	clear: both;
	text-align: right;
	}
	label {
    display: inline-block;
	margin-left: 6px;
	cursor: pointer;
	}
	.width-1-4 {
    float: left;
    width: 25%;
	margin-bottom: 16px;
	}
</style>
<?php
	global $TEMPLATE, $LANG, $SITEURL;
	if(!defined('IN_GS') || !cookie_check()) die('You cannot load this page directly.');
	include('inc/data_contact.php');
	include('inc/data_search.php');
	$def_lang=$LANG;
	if(!isset($def_lang) || empty($def_lang)) $def_lang="en_US";
	if(!file_exists(str_replace('\\','/',dirname(__FILE__)).'/lang/'.$def_lang.'.php')) $def_lang="en_US";
	include(str_replace('\\','/',dirname(__FILE__)).'/lang/'.$def_lang.'.php');

	if(return_theme_setting('contact_form')==1) check_data_contact();
	else uncheck_data_contact();
	
	if(return_theme_setting('search_form')==1) check_data_search();
	else uncheck_data_search();
	
	if(isset($_POST['compress'])) {
		$path_root = (strpos($_SERVER['DOCUMENT_ROOT'], 'http') === true) ? $_SERVER['DOCUMENT_ROOT'] : substr($_SERVER['SCRIPT_FILENAME'], 0, strpos($_SERVER['SCRIPT_FILENAME'], '/admin'));
		if($_POST['compress']==1) {
			$ht_file = fopen($path_root."/.htaccess", "r") or die($set_lang['FX_FILE_ERROR'].".htaccess!");
			$fileHand = fread($ht_file, filesize($path_root."/.htaccess"));
			fclose($ht_file);
			rename($path_root."/.htaccess", $path_root."/.htaccess.old");
			$ht_file1 = fopen($path_root."/.htaccess", "w") or die($set_lang['FX_FILE_ERROR'].".htaccess!");
			fwrite($ht_file1, $fileHand);
			$comp_txt = PHP_EOL.PHP_EOL.'## Enable gzip compression ##'.PHP_EOL.'<IfModule mod_deflate.c>'.PHP_EOL.'  # Compress HTML, CSS, JavaScript, Text, XML and fonts'.PHP_EOL.'  AddOutputFilterByType DEFLATE application/javascript'.PHP_EOL.'  AddOutputFilterByType DEFLATE application/rss+xml'.PHP_EOL.'  AddOutputFilterByType DEFLATE application/vnd.ms-fontobject'.PHP_EOL.'  AddOutputFilterByType DEFLATE application/x-font'.PHP_EOL.'  AddOutputFilterByType DEFLATE application/x-font-opentype'.PHP_EOL.'  AddOutputFilterByType DEFLATE application/x-font-otf'.PHP_EOL.'  AddOutputFilterByType DEFLATE application/x-font-truetype'.PHP_EOL.'  AddOutputFilterByType DEFLATE application/x-font-ttf'.PHP_EOL.'  AddOutputFilterByType DEFLATE application/x-javascript'.PHP_EOL.'  AddOutputFilterByType DEFLATE application/xhtml+xml'.PHP_EOL.'  AddOutputFilterByType DEFLATE application/xml'.PHP_EOL.'  AddOutputFilterByType DEFLATE font/opentype'.PHP_EOL.'  AddOutputFilterByType DEFLATE font/otf'.PHP_EOL.'  AddOutputFilterByType DEFLATE font/ttf'.PHP_EOL.'  AddOutputFilterByType DEFLATE image/svg+xml'.PHP_EOL.'  AddOutputFilterByType DEFLATE image/x-icon'.PHP_EOL.'  AddOutputFilterByType DEFLATE text/css'.PHP_EOL.'  AddOutputFilterByType DEFLATE text/html'.PHP_EOL.'  AddOutputFilterByType DEFLATE text/javascript'.PHP_EOL.'  AddOutputFilterByType DEFLATE text/plain'.PHP_EOL.'  AddOutputFilterByType DEFLATE text/xml'.PHP_EOL.PHP_EOL.'  # Remove browser bugs (only needed for really old browsers)'.PHP_EOL.'  BrowserMatch ^Mozilla/4 gzip-only-text/html'.PHP_EOL.'  BrowserMatch ^Mozilla/4\.0[678] no-gzip'.PHP_EOL.'  BrowserMatch \bMSIE !no-gzip !gzip-only-text/html'.PHP_EOL.'  Header append Vary User-Agent'.PHP_EOL.'</IfModule>';
			fwrite($ht_file1, $comp_txt);
			fclose($ht_file1);
			chmod($path_root."/.htaccess", 0644);
		}
		else {
			if(file_exists($path_root."/.htaccess.old")) {
				unlink($path_root."/.htaccess");
				rename($path_root."/.htaccess.old", $path_root."/.htaccess");
			}
		}
	}
	if(in_array('zlib', get_loaded_extensions()) || in_array('Phar', get_loaded_extensions())) {
		$is_gzip = true;
		$is_defl = true;
	} else {
		$is_gzip = false;
		$is_defl = false;
	}
?>

<fieldset class="container-collapsed widesec" id="container-1">
	<legend class="collapsedlegend" id="legend-1"><?php echo $set_lang['FX_SET_EXPAND']; ?></legend>
	<h3 style="margin:20px 10px"><?php echo $set_lang['FX_MAIN_SETTINGS']; ?></h3>
	<div class="expand-settings">
		<div class="inner-divs">
			<div class="leftsec" style="width:48%;padding-right:2%;">
				<p>
					<label for="tagline"><?php echo $set_lang['SITE_PHONE']; ?></label>
					<input type="text" class="text" name="phone" id="phone" value="<?php get_theme_setting('phone'); ?>">
				</p>
			</div>
			<div class="rightsec">
				<p>
					<label for="site_slogan"><?php echo $set_lang['SLOGAN_LINE']; ?></label>
					<input type="text" class="text" name="site_slogan" id="site_slogan" value="<?php get_theme_setting('site_slogan'); ?>">
				</p>
			</div>
			<div class="leftsec">
				<p>
					<input type="checkbox" name="contact_form" value=1 <?php echo return_theme_setting('contact_form')==1?"checked":"" ?>><span class="ra-settings"><?php echo $set_lang['CONTACT_SET']; ?></span>
				</p>
			</div>
			<div class="rightsec">
				<p>
				<input type="checkbox" name="search_form" value=1 <?php echo return_theme_setting('search_form')==1?"checked":"" ?>><span class="ra-settings"><?php echo $set_lang['SEARCH_SET']; ?></span>
				</p>
			</div>
				<p style="padding-bottom: 20px;">
					<label for="logofile"><?php echo $set_lang['SITE_LOGO']; ?></label>
					<input type="text" class="text" name="logofile" id="logofile" value="<?php get_theme_setting('logofile'); ?>" placeholder="<?php echo $set_lang['SITE_LOGO_DESC']; ?>" style="width: 74%;">
					<span class="edit-nav"><a id="browse-logo" href="#" style="line-height: 20px ! important;"><?php echo $set_lang['LOGO_BUTTON']; ?></a></span>
				</p>
		</div>
	</div>
</fieldset>

<fieldset class="container-collapsed widesec" id="container-3">
	<legend class="collapsedlegend" id="legend-3"><?php echo $set_lang['FX_SET_EXPAND']; ?></legend>
	<h3 style="margin:20px 10px"><?php echo $set_lang['FX_SITE_OPTI']; ?></h3>
	<div class="expand-settings">
		<div class="inner-divs">
			<p><?php echo $set_lang['FX_OPT_DESC']; ?></p>
			<div class="leftsec">
			<?php echo $is_gzip ? '<p style="color:green;">Module <b>mod_gzip</b> enabled - OK</p>' : '<p style="color:red;">Module <b>mod_gzip</b> disabled - Failed !</p>';	?>
			</div>
			<div class="rightsec">
			<?php echo $is_defl ? '<p style="color:green;">Module <b>mod_deflate</b> enabled - OK</p>' : '<p style="color:red;">Module <b>mod_deflate</b> disabled - Failed !</p>'; ?>
			</div>
			<p>
				<input type='hidden' value='0' name='compress'>
				<input type="checkbox" id="compress" name="compress" value=1 <?php echo return_theme_setting('compress')==1?"checked":"" ?>><label for="compress" class="ra-settings"><?php echo $set_lang['COMPRESS_SET']; ?></label>
			</p>
			<p><?php echo $set_lang['FX_APACHE']; ?></p>
		</div>
	</div>
</fieldset>

<fieldset class="container-collapsed widesec" id="container-2">
	<legend class="collapsedlegend" id="legend-2"><?php echo $set_lang['FX_SET_EXPAND']; ?></legend>
	<h3 style="margin:20px 10px"><?php echo $set_lang['FX_MAPS']; ?></h3>
	<div class="expand-settings">
		<div class="inner-divs">
			<p>
				<input type="checkbox" name="gmaps" id="gmaps" value=1 <?php echo return_theme_setting('gmaps')==1?"checked":"" ?>><span class="ra-settings"><?php echo $set_lang['FX_MAPS_ENABLE']; ?></span>
			</p>
			<?php if(return_theme_setting('gmaps')) $maps_options = "display:block;";
			else $maps_options = "display:none;"; ?>
			<div id="gmapsoptions" style="<?php echo $maps_options; ?>">
				<div class="inner-divs">
					<p><label for="map-address"><?php echo $set_lang['FX_MAPS_ADDR']; ?></label>
					<input type="text" class="text" name="map-address" id="map-address" value="<?php get_theme_setting('map-address'); ?>"></p>
				</div>
				<div class="leftsec">
					<p>
						<label for="map-lat"><?php echo $set_lang['FX_MAPS_LAT']; ?></label>
						<input type="text" class="text" name="map-lat" id="map-lat" style="width: 80%;" value="<?php echo return_theme_setting('map-lat')?return_theme_setting('map-lat'):38.8987394 ?>">
					</p>
				</div>
				<div class="rightsec">
					<p>
						<label for="map-lot"><?php echo $set_lang['FX_MAPS_LONG']; ?></label>
						<input type="text" class="text" name="map-lot" id="map-lot" style="width: 80%;" value="<?php echo return_theme_setting('map-lot')?return_theme_setting('map-lot'):-77.0372789 ?>">
					</p>
				</div>
				<div class="leftsec">
					<p>
						<label for="map-marker"><?php echo $set_lang['FX_MAPS_MARKER']; ?></label>
						<input type="text" class="text" name="map-marker" id="map-marker" maxlength="1" style="width: 20px;margin: 10px 0;" value="<?php  echo return_theme_setting('map-marker')?return_theme_setting('map-marker'):'A' ?>">
					</p>
					<p>
						<label for="map-markersize"><?php echo $set_lang['FX_MAPS_MARKER_SIZE']; ?></label>
						<select name="map-markersize" id="map-markersize" class="text" style="width: auto;">
							<option value="mid" <?php echo return_theme_setting('map-markersize')=='min'?"selected":"" ?>>Normal</option>
							<option value="small" <?php echo return_theme_setting('map-markersize')=='small'?"selected":"" ?>>Small</option>
							<option value="tiny" <?php echo return_theme_setting('map-markersize')=='tiny'?"selected":"" ?>>Tiny</option>
						</select>
					</p>
					<p>
						<label for="map-color"><?php echo $set_lang['FX_MAPS_MARKER_COLOR']; ?></label>
						<select name="map-color" id="map-color" class="text" style="width: auto;">
							<option value="red" <?php echo return_theme_setting('map-color')=='red'?"selected":"" ?> style="background-color: red;color: white;">Red</option>
							<option value="black" <?php echo return_theme_setting('map-color')=='black'?"selected":"" ?> style="background-color: black;color: white;">Black</option>
							<option value="white" <?php echo return_theme_setting('map-color')=='white'?"selected":"" ?>>White</option>
							<option value="blue" <?php echo return_theme_setting('map-color')=='blue'?"selected":"" ?> style="background-color: blue;color: white;">Blue</option>
							<option value="green" <?php echo return_theme_setting('map-color')=='green'?"selected":"" ?> style="background-color: green;color: white;">Green</option>
							<option value="yellow" <?php echo return_theme_setting('map-color')=='yellow'?"selected":"" ?> style="background-color: yellow;color: black;">Yellow</option>
							<option value="gray" <?php echo return_theme_setting('map-color')=='gray'?"selected":"" ?> style="background-color: gray;color: black;">Gray</option>
						</select>
					</p>
				</div>
				<div class="rightsec">
					<p>
						<label for="map-size"><?php echo $set_lang['FX_MAPS_SIZE']; ?></label>
						<input type="text" class="text" name="map-size" id="map-size" style="width: 60px;" value="<?php echo return_theme_setting('map-size')?return_theme_setting('map-size'):'640x640' ?>">
					</p>
					<p>
						<label for="map-type"><?php echo $set_lang['FX_MAPS_TYPE']; ?></label>
						<select name="map-type" id="map-type" class="text" style="width: auto;">
							<option value="roadmap" <?php echo return_theme_setting('map-type')=='roadmap'?"selected":"" ?>>Roadmap</option>
							<option value="satellite" <?php echo return_theme_setting('map-type')=='satellite'?"selected":"" ?>>Satellite</option>
							<option value="terrain" <?php echo return_theme_setting('map-type')=='terrain'?"selected":"" ?>>Terrain</option>
							<option value="hybrid" <?php echo return_theme_setting('map-type')=='hybrid'?"selected":"" ?>>Hybrid</option>
						</select>
					</p>
					<p>
						<label for="map-zoom"><?php echo $set_lang['FX_MAPS_ZOOM']; ?></label>
						<input type="text" class="text" name="map-zoom" id="map-zoom" maxlength="2" style="width: 20px;" value="<?php echo return_theme_setting('map-zoom')?return_theme_setting('map-zoom'):14 ?>">
					</p>
				</div>
				<div class="leftsec">
					<p>
						<label for="map-place"><?php echo $set_lang['FX_MAPS_PLACE']; ?></label>
						<select name="map-place" id="map-place" class="text" style="width: auto;">
							<option value="top" <?php echo return_theme_setting('map-place')=='top'?"selected":"" ?>>On Top</option>
							<option value="side" <?php echo return_theme_setting('map-place')=='side'?"selected":"" ?>>On Side</option>
							<option value="bottom" <?php echo return_theme_setting('map-place')=='bottom'?"selected":"" ?>>On Bottom</option>
						</select>
					</p>
				</div>
				<div class="rightsec">
					<p>
						<input type="checkbox" name="map-fa" value=1 <?php echo return_theme_setting('map-fa')==1?"checked":"" ?>><span class="ra-settings"><?php echo $set_lang['FX_MAPS_FA']; ?></span>
					</p>
				</div>
				<div style="clear:both;"></div>
				<div class="leftsec">
					<p>
						<label for="map-key"><?php echo $set_lang['FX_MAPS_KEY']; ?></label>
						<input type="text" class="text" name="map-key" id="map-key" style="width: 80%;" value="<?php  echo return_theme_setting('map-key')?return_theme_setting('map-key'):'' ?>">
					</p>
				</div>
				<div class="rightsec">
					<p style="line-height: 50px;">
						<a href="https://developers.google.com/maps/documentation/javascript/get-api-key" target="_blank"><?php echo $set_lang['FX_MAPS_GETKEY']; ?></a>
					</p>
					</div>
				<p style="font-style:italic;"><?php echo $set_lang['FX_MAPS_DESC']; ?></p>
			</div>
			
		</div>
	</div>
</fieldset>
<fieldset class="container-collapsed widesec" id="container-3">
	<legend class="collapsedlegend" id="legend-10"><?php echo $set_lang['FX_SET_EXPAND']; ?></legend>
	<h3 style="margin:20px 10px"><?php echo $set_lang['SEARCH_SETTINGS']; ?></h3>
	<div class="component-settings">
		<div class="inner-divs">
			<p>
				<input type="checkbox" name="search_internal" value=1 <?php echo return_theme_setting('search_internal')==1?"checked":"" ?>><span class="ra-settings"><?php echo $set_lang['SEARCH_INTERNAL']; ?></span>
			</p>
			<div class="leftsec">
				<p>
					
					<input type="checkbox" name="search_logic" value=1 <?php echo return_theme_setting('search_logic')==1?"checked":"" ?>><span class="ra-settings"><?php echo $set_lang['SEARCH_LOGIC']; ?></span>
				</p>
			</div>
			<div class="rightsec">
				<p>
					<input type="checkbox" name="search_meta" value=1 <?php echo return_theme_setting('search_meta')==1?"checked":"" ?>><span class="ra-settings"><?php echo $set_lang['SEARCH_META']; ?></span>
				</p>
			</div>
			<div class="leftsec">
				<p>
					<input type="checkbox" name="search_blank" value=1 <?php echo return_theme_setting('search_blank')==1?"checked":"" ?>><span class="ra-settings"><?php echo $set_lang['SEARCH_BLANK']; ?></span>
				</p>
			</div>
			<div class="rightsec">
				<p>
					<label for="search_excerpt" style="display: inline-block;font-weight: normal;"><?php echo $set_lang['SEARCH_EXCERPT']; ?>: </label>
					<input type="text" class="text" name="search_excerpt" id="search_excerpt" value="<?php get_theme_setting('search_excerpt'); ?>" style="width: 50px;">
				</p>
			</div>
		</div>
	</div>
</fieldset>

<p style="text-align:center">© 2015 Andrejus Semionovas (aka asemion) - Please consider a <a href="https://www.paypal.com/cgi-bin/webscr?cmd=_s-xclick&hosted_button_id=RRPX5MZZJX4MW" target="_blank">Donation</a></p>
<script type="text/javascript">
	jQuery('.collapsedlegend').click(function(){
		var path = '<?php echo $SITEURL; ?>';
		var expand = '<?php echo $set_lang['FX_SET_EXPAND']; ?>';
		var colapse = '<?php echo $set_lang['FX_SET_COLAPS']; ?>';
		if($(this).text()==expand){
			$(this).parents('fieldset').find('div:first').show(500);
			$(this).text(colapse);
			$(this).css('background-image', 'url('+path+'admin/template/images/tick.png)');
			}else{
			$(this).parents('fieldset').find('div:first').hide(500);
			$(this).text(expand);
			$(this).css('background-image', 'url('+path+'admin/template/images/utick.png)');
		}
	});
	
	jQuery('#gmaps').change(function(){
		if(document.getElementById('gmaps').checked) {
			$("#gmapsoptions").css("display", "block");
			} else {
			$("#gmapsoptions").css("display", "none");
		}
	})

	function fill_img_url(url) {
		$('#logofile').val(url);
	}
	$(function() { 
		$('#browse-logo').click(function(e) {
			e.preventDefault();
			window.open('../theme/<?php echo $TEMPLATE?>/browser/filebrowser.php?func=fill_img_url&type=images', 'browser', 'width=800,height=500,left=100,top=100,scrollbars=yes');
		});
	});
</script>