<?php if(!defined('IN_GS')){ die('you cannot load this page directly.'); }
/****************************************************
*
* @File: 			functions.php
* @Package:		GetSimple
* @Action:		Skeleton theme for GetSimple CMS
*
*****************************************************/
$active_class_main = 'active';		//You can change this parameter as needed
$active_class_append = '';		//You can change this parameter as needed
$active_class_prepend = '';	//You can change this parameter as needed
$level_key;
function AddPageToNavbar($page, $currentpage, $pagesSorted, $level, $target, $parent_path, $sub_opened, $url_prefix = '') {
	global $active_class_append, $active_class_prepend, $level_key;
	// Make sure there's both a menu and title attribute
	if ($page['menu'] == '') { $page['menu'] = $page['title']; }
	if ($page['title'] == '') { $page['title'] = $page['menu']; }
	$out = '';
	$clases = '';
	$sub_clases = "";
	$is_icon = "";
	$checked = '';
	$carret = '';
	if(isset($page['metad']) && strpos($page['metad'], 'menu_class=') !== false || isset($page['metad']) && strpos($page['metad'], 'menu_icon=') !== false) {
		$is_highlighted = explode(';', $page['metad']);
		foreach($is_highlighted as $highlight) {
			if(strpos($highlight, 'menu_class=') !== false) {
				$clases .= substr($highlight, strpos($highlight, 'menu_class=')+11, strlen($highlight));
			}
			if(strpos($page['metad'], 'menu_icon=') !== false) {
				$ck_icon = substr($highlight, strpos($highlight, 'menu_icon=')+10, strlen($highlight));
				$is_icon = ' <i class="icon '.$ck_icon.'"></i>';
			}
		}
	}
	if(strpos($page['url'], '_') !== false) $page['url'] = substr($page['url'], 0, strpos($page['url'], '_'));
	if(strpos($page['parent'], '_') !== false) $page['parent'] = substr($page['parent'], 0, strpos($page['parent'], '_'));
	// Check if the page has children
	$Children = returnChildrens($page['slug']);
	if(count($Children) > 0) {
		$clases .= 'parent ';
		if(in_array($page['url'], $parent_path)) {
			$level_key = array_search($page['url'], $parent_path);
			if(!empty($active_class_append)) {
				$clases .= ' '.$active_class_append.$level_key;
			}
		}
		if(strtolower($target) == 'main') {
			if($level & 1) {
				$carret = ' <i class="icon-caret-down"></i>';
			} else {
				$carret = ' <i class="icon-caret-right"></i>';
			}
		}
		elseif(strtolower($target) != 'main-top-level' && strtolower($target) != 'offcanvas-top-level') {
			if($sub_opened && count($parent_path) > 0) {
				if($page['url'] == returnFieldValue(get_parent(false), 'parent')) {
					$sub_clases = " sub-open";
					$clases .= ' li-open';
					$checked = ' checked';
				}
				if($page['url'] == get_parent(false)) {
					$sub_clases = " sub-open";
					$clases .= ' li-open';
					$checked = ' checked';
				}
			}
			if(strpos(strtolower($target), 'context') !== false) $suffix = "-context";
			else $suffix = "";
			if(strpos(strtolower($target), 'context') !== false) {
				if(strtolower($target) == 'context-noparents-current') {
					if($level == 1) {
						$out .= '<li class="first-menu-item uppercase"><span class="menu-title-icon">'.$page['menu'].'</span></li>';
					}
					if($level > 1) {
						$carret = ($level > 0) ? '<input id="'.$page['url'].'-toggle'.$suffix.'" type="checkbox" class="menu-item hidden"'.$checked.'><label for="'.$page['url'].'-toggle'.$suffix.'" class="menu-toggle-no-parents-link">'.strip_decode($page['menu']).'</label>' : '';
					}
				}
				elseif(strtolower($target) != 'context-sitemap') {
					$carret = ($level > 0) ? '<input id="'.$page['url'].'-toggle'.$suffix.'" type="checkbox" class="menu-item hidden"'.$checked.'><label for="'.$page['url'].'-toggle'.$suffix.'" class="menu-toggle-no-parents-link">'.strip_decode($page['menu']).'</label>' : '';
				}
			} 
			else {
				$carret = ($level > 0) ? '<input id="'.$page['url'].'-toggle'.$suffix.'" type="checkbox" class="menu-item hidden"'.$checked.'><label for="'.$page['url'].'-toggle'.$suffix.'" class="menu-item-toggle"></label>' : '';
			}
		}
	}
	
	if($currentpage == $page['url']) {
		if(!empty($active_class_append)) {
			if(count($parent_path) > 0) $level_key = $level_key+1;
			else $level_key = 0;
			$clases .= (empty($clases)?'':' ').$active_class_append.($level_key);
			if(!empty($active_class_prepend)) {
				$clases .= (empty($clases)?'':' ').$active_class_append.($level_key).$active_class_prepend;
			}
			if(!empty($active_class_main)) $clases .= $clases.' '.$active_class_main;
		}
	}
	if(strtolower($target) == 'main') {
		if($currentpage == $page['url'] && $level == 1) $clases .= ' active';
		if(!empty($clases)) $out .= '<li id="'.$page['url'].'" class="'.$clases.'">';
		else $out .= '<li id="'.$page['url'].'">';
		$out .= '<a href="' . find_url($page['url'], $page['parent']) . $url_prefix . '" title="' . encode_quotes(cl($page['title'])) . '">' . $is_icon . strip_decode($page['menu']) . $carret.'</a>';
	} 
	else {
		if($currentpage == $page['url']) $clases .= ' active';
		if(!empty($clases)) $out .= '<li id="'.$page['url'].'" class="'.$clases.'">';
		else $out .= '<li id="'.$page['url'].'">';
		if(strtolower($target) == 'context-noparents' || strtolower($target) == 'context-noparents-current') {
			$out .=  $carret;
			if(count($Children) == 0) {
				$out .=  $carret.'<a href="' . find_url($page['url'], $page['parent']) . $url_prefix . '" title="' . encode_quotes(cl($page['title'])) . '"  class="no-parents-links">' . $is_icon . strip_decode($page['menu']).'</a>';
			}
		} 
		else {
			$out .=  $carret.'<a href="' . find_url($page['url'], $page['parent']) . $url_prefix . '" title="' . encode_quotes(cl($page['title'])) . '">' . $is_icon . strip_decode($page['menu']).'</a>';
		}
	}
	if (count($Children) > 0 && strtolower($target) != 'main-top-level' && strtolower($target) != 'offcanvas-top-level') {
		if($level == 1) {
			if(strtolower($target) == 'context-noparents-current') $sub_clases = " sub-opened";
			$out .= '<ul class="nav-navbar nav-sub'.$sub_clases.'">';
		}
		elseif ($level > 1) {
			if($level & 1) {
				$out .= '<ul class="nav-sub'.$sub_clases.'">';
			}
			else {
				$out .= '<ul class="nav-sub to-right'.$sub_clases.'">';
			}
		}
		else $out .= '<ul>';
		if(strtolower($target) != 'main-top-level' && strtolower($target) != 'offcanvas-top-level') {
			foreach ($pagesSorted as $Child) {
				if ((in_array($Child['url'], $Children)) && ($Child['menuStatus'] == 'Y') && (($Child['private'] != 'Y') || ((isset($USR) && $USR == get_cookie('GS_ADMIN_USERNAME'))))) {
					if (isset($Child['metad']) && $Child['metad'] != '' && strpos(strtolower($Child['metad']), 'activetab_') !== false) {
						$url_prefix = str_replace('activetab_', '#', $Child['metad']);
					} else { $url_prefix = ''; }
					$out .= AddPageToNavbar($Child, $currentpage, $pagesSorted, $level + 1, $target, $parent_path, $sub_opened, $url_prefix);
				}
			}
		}
		$out .= '</ul>';
	}
	return $out;
}
	 
function get_navigation_items($currentpage, $target='main', $is_animated=false, $is_sub_open=true, $is_lang_menu=false, $current_language="en") {
	global $pagesArray, $USR, $pagesSorted;
	if(function_exists('return_i18n_available_languages') && count(return_i18n_available_languages()) > 1) {
		$multi_lang = true;
	}
	else {
		$multi_lang = false;
	}
	if($is_sub_open) $sub_opened = true;
	else $sub_opened = false;
	if($is_animated) {
		$animated = " animated";
		if(strtolower($target) == 'main') $animated .= " fadeInUp";
	}
	else $animated = "";
	if(strtolower($target) == 'offcanvas' || strtolower($target) == 'offcanvas-top-level') { ?>
	<div class="nav-container center">
		<input id="toggle-offcanvas" type="checkbox">
		<label for="toggle-offcanvas" class="navbar-toggle"></label>
		<div class="visible-small">
			<?php get_site_name(); ?>
		</div>
		<div id="my-offcanvas" class="offcanvas">
			<div class="offcanvas-bar">
				<ul class="nav-offcanvas<?php echo $animated; ?>">	<?php
	} else {
		if(strpos(strtolower($target), 'context') !== false) { ?>
			<ul class="nav-context<?php echo $animated; ?> <?php echo strtolower($target); ?>">
		<?php } else { ?>
			<!-- main navigation -->
		<nav id="main-navbar" class="nav navbar-nav">
			<ul class="navbar-nav<?php echo $animated; ?>"> 
		<?php }
	}
		$menu = '';
		if($multi_lang) {
			$langs_arr = return_i18n_languages();
			$current_language = $langs_arr[0];
			$pagesSort = $pagesArray;
			$array_parents = array();
			foreach($pagesSort as $elementKey => $element) {
				if(isset($element['parent']) && !empty($element['parent'])) {
					$parent_en = $element['parent'];
					$array_parents[$element['url']] = $element['parent'];
				}
			}
			foreach($pagesSort as $elementKey => $element) {
				foreach($element as $valueKey => $value) {
					if($current_language == 'en') {
						if($valueKey == 'url' && strpos($value, '_') !== false) {
							unset($pagesSort[$elementKey]);
						}
					}
					else {
						if($valueKey == 'url' && strpos($value, '_'.$current_language) === false) {
							unset($pagesSort[$elementKey]);
						}
					}
					if($valueKey == 'menuStatus' && $value != 'Y') {
						unset($pagesSort[$elementKey]);
					} 
				}
			}
			
			foreach($pagesSort as &$elementKey) {
				$in_parent = substr($elementKey['url'], 0, strpos($elementKey['url'], '_'));
				if($current_language != 'en') {
					$menu_order = $pagesArray[$in_parent]['menuOrder'];
					$elementKey['menuOrder'] = $menu_order;
				}
				
				if(isset($array_parents[$in_parent])) {
					$elementKey['parent'] = $array_parents[$in_parent].'_'.$current_language;
				}
			}
			$pagesSort = subval_sort($pagesSort, 'menuOrder');
		}
		else {
			$pagesSort = subval_sort($pagesArray, 'menuOrder');
			/***  Remove elements that are not in menu  ***/
			foreach($pagesSort as $elementKey => $element) {
				foreach($element as $valueKey => $value) {
					if($valueKey == 'menuStatus' && $value != 'Y'){
						unset($pagesSort[$elementKey]);
					} 
				}
			}
			/***  End elements removing  ***/
		}
		$pagesSorted = $pagesSort;
		$parent_cur = ($multi_lang && $current_language != "en" && strpos(returnFieldValue($currentpage, 'parent'), '_') === false) ? returnFieldValue($currentpage, 'parent').'_'.$current_language : returnFieldValue($currentpage, 'parent');
		$parent_curr = ($multi_lang && strpos(returnFieldValue($currentpage, 'parent'), '_') !== false) ? substr(returnFieldValue($currentpage, 'parent'), 0, strpos(returnFieldValue($currentpage, 'parent'), '_')) : returnFieldValue($currentpage, 'parent');
		if(empty($parent_curr)) $parent_curr = $currentpage;
		$parent_path=array();
		if($parent_curr != '') {
			for($i=0; $i<count($pagesSorted); $i++){
				foreach ($pagesSorted as $page) {
					$page_parent = 	($multi_lang && strpos($page['parent'], '_') !== false) ? substr($page['parent'], 0, strpos($page['parent'], '_')) : $page['parent'];
					$page_slug = ($multi_lang && strpos($page['slug'], '_') !== false) ? substr($page['slug'], 0, strpos($page['slug'], '_')) : $page['slug'];
					$parent_url = ($multi_lang && strpos(returnFieldValue($parent_curr, 'url'), '_') !== false) ? substr(returnFieldValue($parent_curr, 'url'), 0, strpos(returnFieldValue($parent_curr, 'url'), '_')) : returnFieldValue($parent_curr, 'url');
					$parent_slug = ($multi_lang && $current_language != "en" && strpos(returnFieldValue($parent_curr, 'slug'), '_') === false) ? returnFieldValue($parent_curr, 'slug').'_'.$current_language : returnFieldValue($parent_curr, 'slug');
					if($page_slug == $parent_curr && $page_parent){
						if($parent_curr != '') $parent_curr = $page_parent;
						$parents = array('url'=>$parent_url, 'parent'=>returnFieldValue($parent_curr, 'parent'), 'menu'=>returnFieldValue($parent_cur, 'menu'), 'slug'=>$parent_slug, 'title'=>returnFieldValue($parent_cur, 'title'));
						$parent_path[] = $parent_url;
						$parent_path[] = $parent_curr;
					}
					else {
						if($currentpage == 'search' && $current_language != "en") {
							$parents = array('url' => 'search', 'parent' =>'', 'menu' =>get_lang_param('FX_SEARCH'), 'slug' =>$parent_slug, 'title' =>get_lang_param('FX_SEARCH'));
						}
						else {
						$parent_slug = ($multi_lang && $current_language != "en" && strpos($parent_slug, '_') === false) ? $parent_slug.'_'.$current_language : $parent_slug;
						$parents = array('url' => $parent_url, 'parent' =>returnFieldValue($parent_url, 'parent'), 'menu' =>returnFieldValue($parent_slug, 'menu'), 'slug' =>$parent_slug, 'title' =>returnFieldValue($parent_slug, 'title'));
						}
					}
					if($page_slug == $parent_curr) {
						$parent_path[] = $parent_url;
					}
				}
			}
		}
		else {
			if($parent_curr != '') {
				$parent_url = ($multi_lang && strpos(returnFieldValue($parent_curr, 'url'), '_') !== false) ? substr(returnFieldValue($parent_curr, 'url'), 0, strpos(returnFieldValue($parent_curr, 'url'), '_')) : returnFieldValue($parent_curr, 'url');
				$parents = array('url' => $parent_url, 'parent' =>returnFieldValue($currentpage, 'parent'), 'menu' =>returnFieldValue($currentpage, 'menu'), 'slug' =>returnFieldValue($currentpage, 'slug'), 'title' =>returnFieldValue($currentpage, 'title'));
			}
			else { 
				$parents = array('url' => $currentpage, 'parent' =>returnFieldValue($currentpage, 'parent'), 'menu' =>returnFieldValue($currentpage, 'menu'), 'slug' =>returnFieldValue($currentpage, 'slug'), 'title' =>returnFieldValue($currentpage, 'title'));
			}
		}
		if (count($pagesSorted) != 0) {
			if (isset($page['metad']) && $page['metad'] != '' && strpos(strtolower($page['metad']), 'activetab_') !== false) {
				$url_prefix = str_replace('activetab_', '#', $page['metad']);
			} else { $url_prefix = ''; }
			if(strtolower($target) == 'context-noparents-current' && count($parents) > 0) {
				$menu .= AddPageToNavbar($parents, $currentpage, $pagesSorted, 1, $target, $parent_path, $sub_opened, $url_prefix);
			}
			else {
				foreach ($pagesSorted as $page) {
					if ((!$page['parent']) && ($page['menuStatus'] == 'Y') && (($page['private'] != 'Y') || ((isset($USR) && $USR == get_cookie('GS_ADMIN_USERNAME'))))) {
						$menu .= AddPageToNavbar($page, $currentpage, $pagesSorted, 1, $target, $parent_path, $sub_opened, $url_prefix);
					}
				}
			}
		}
		echo exec_filter('menuitems',$menu);
	if(strtolower($target) == 'offcanvas' || strtolower($target) == 'offcanvas-top-level') {
		if($is_lang_menu && function_exists('get_i18n_lang_menu')) {
			get_i18n_lang_menu(true);
		} ?>
				</ul>
			</div>
		</div>
	</div> <?php
	} elseif(strpos(strtolower($target), 'context') !== false) {
		 ?>	</ul> <?php
	} else { 
		if($is_lang_menu && function_exists('get_i18n_lang_menu')) {
			get_i18n_lang_menu();
		} ?>
			</ul>
		</nav> <?php
	}
}

function returnPageData($page, $field='content', $raw = false, $nofilter = false){   
	if(file_exists(GSDATAPAGESPATH.$page.'.xml')) {
		$thisfile = file_get_contents(GSDATAPAGESPATH.$page.'.xml');
		$data = simplexml_load_string($thisfile);
		if(!$data) return;
		$content = $data->$field;
		if(!$raw) $content = stripslashes(htmlspecialchars_decode($content, ENT_QUOTES));
		if ($field=='content' and !$nofilter){
			$content = exec_filter('content',$content);
		}
	} else {
		$content = false;
	}
  	return $content;
}
function returnFieldValue($page,$field){   
	global $pagesArray;
	if(!$pagesArray) getPagesXmlValues();	
	if ($field=="content"){
	  $ret=returnPageData($page); 
	} else {
		if (isset($pagesArray[(string)$page]) && array_key_exists($field, $pagesArray[(string)$page])){
	  		$ret=strip_decode(@$pagesArray[(string)$page][(string)$field]);
		} else {
			$ret = returnPageData($page,$field);
		}
	} 
	return $ret;
}

/***  Function for Menu Item Childrens finding ***/
function returnChildrens($page){
	global $pagesSorted;
	$returnArray = array();
	foreach ($pagesSorted as $key => $value) {
		if ($pagesSorted[$key]['parent']==$page && $pagesSorted[$key]['menuStatus'] == 'Y'){
		  $returnArray[]=$value['url'];
	    }
	}
	return $returnArray;
}

/***  Function to get variables from Lang array  ***/
function get_lang_param($name="") {
	if(empty($name)) return false;
	if(isset($_COOKIE['current_lang'])) $def_lang = $_COOKIE['current_lang'];
	if(!isset($def_lang)) {
		global $language;
		if(isset($language) && !empty($language)) $def_lang=$language;
		else {
			$LANG = getDefaultLanguage();
			if(isset($LANG) && !empty($LANG) && substr($LANG,0,2)!="en") $def_lang = getDefaultLanguage();
			else $def_lang="en_US";
		}
		if($def_lang == "en") $def_lang = "en_US";
		if(strlen($def_lang)<3) $def_lang = $def_lang.'_'.strtoupper($def_lang);
	}
	if (file_exists(str_replace('\\','/',dirname(__FILE__)).'/lang/'.$def_lang.'.php')) {
		require(str_replace('\\','/',dirname(__FILE__)).'/lang/'.$def_lang.'.php');
	}
	if(isset($set_lang[$name]) && !empty($set_lang[$name])) $lang_param = $set_lang[$name];
	else $lang_param = "Search";
	return $lang_param;
}

/***  Search function  ***/
function return_setting($name) {
	global $TEMPLATE;
	$theme = (string) $TEMPLATE;
	$data = getXML(GSDATAOTHERPATH.'theme_settings_'.$theme.'.xml');
	if(isset($data->$name) && !empty($data->$name)) $field_data = $data->$name;
	else $field_data = false;
	unset($data);
	return $field_data;
}
if(return_setting('search_excerpt')) {
	$excerpt = return_setting('search_excerpt');
	$search_exc = (int) $excerpt;
}
else $search_exc = 200;

define('EXCERPTLENGTH', $search_exc);

function get_search_results($use_meta=false) {
	if(!isset($_POST['keywords']) || empty($_POST['keywords'])) {
		echo '<p style="color:red;">'.get_lang_param('FX_SEARCH_KEYWNOT').'</p>';
		return;
	}
	$keywords = array();
	if(return_setting('search_logic')==1) {
		$keywords[] = $_POST['keywords'];
		} else {
		$keywords = @explode(' ', $_POST['keywords']);
	}
	$keywords = array_filter($keywords);
	if(empty($keywords)) return;
	$pages = get_pages();
	$multi_lang = false;
	if (function_exists('return_i18n_available_languages') && count(return_i18n_available_languages()) > 1) $multi_lang = true;
	// Find matching documents
	echo '<p>'.get_lang_param('FX_SEARCH_KEYWORDS');
	$match = array();
	foreach ($keywords as $keyword) {
		$keys = 0;
		foreach ($pages as $page) {
			$data = getXML($page);
			$is_found = false;
			if ($data->private != 'Y') {
				if($multi_lang) {
					if (mb_stripos($data->content, $keyword, 0, 'UTF-8') !== false || mb_stripos($data->title, $keyword, 0, 'UTF-8') !== false) {
						$match[] = $page;
						$is_found = true;
						$keys++;
					}
				} else {
					if (stripos($data->content, $keyword) !== false || stripos($data->title, $keyword) !== false) {
						$match[] = $page;
						$is_found = true;
						$keys++;
					}
				}
				if ($use_meta==true && !$is_found) {
					$meta_join = $data->meta.' '.$data->metad;
					$is_meta = false;
					if($multi_lang) {
						if (mb_stripos($meta_join, $keyword, 0, 'UTF-8') !== false) $is_meta = true;
						} else {
						if (stripos($meta_join, $keyword) !== false) $is_meta = true;
					}
					if($is_meta) {
						$match[] = $page;
						$keys++;
					}
				}
			}
			$pages_found = $match;
		}
		echo '<span style="margin-left: 6px;"><strong>'.$keyword.'('.$keys.')</strong></span>';
	}
	echo '</p>';
	// Print results
	if (count($pages_found) > 0) {
		echo '<p>'.get_lang_param('FX_SEARCH_FOUND').' ('.count($pages_found).'):</p>';
		print_search_results($pages_found, $multi_lang);
	} else echo '<p style="color:red;">'.get_lang_param('FX_SEARCH_NOT').'</p>';
}

function print_search_results($pages, $multi_lang=false) {
	global $PRETTYURLS;
	global $SITEURL;
	global $TEMPLATE;
	$counter = 0;
	if(return_setting('search_blank') == 1) {
		$target = "_blank";
	}
	else $target = "_self";
	echo '<ul id="search_results">';
	foreach ($pages as $page) {
		$data = getXML($page);
		$url = ($PRETTYURLS == 1) ? $SITEURL . $data->url : $SITEURL . 'index.php?id=' . $data->url;
		// Extract and filter content
		$content = preg_replace('/&#?[a-z0-9]{2,8};/i', '', stripslashes(strip_tags(html_entity_decode($data->content, ENT_QUOTES, 'UTF-8'))));
		$content = preg_replace('/\s{2,}/', ' ', trim($content));
		$content = preg_replace('/(%[\s\S]+?%)/', '', $content);
		$content = str_replace(array('(',')'),'',$content);
		$content = str_replace('{}','',$content);
		// Create an excerpt of the content
		if(strlen($content) > EXCERPTLENGTH) {
			if($multi_lang) {
				$content = mb_substr($content, 0, mb_strrpos(mb_substr($content, 0, EXCERPTLENGTH), ' ', "UTF-8"), "UTF-8") . ' <a href="' . $url . '" target="'.$target.'">[...]</a>';
				} else {
				$content = substr($content, 0, strrpos(substr($content, 0, EXCERPTLENGTH), ' ')) . ' <a href="' . $url . '" target="'.$target.'">[...]</a>';
			}
			
		}
		// Print result
		if(!strpos($data->url, '_')) $langs = "en";
		else $langs = substr($data->url, strpos($data->url, '_')+1);
		if($multi_lang) {
			if(strpos($url, '_') !== false) $url = substr($url, 0, strpos($url, '_'));
			echo '<li><span class="search-entry-language" style="font-size:16px;font-weight:400;line-height:24px;margin-right:10px;color: #000;">('.$langs.')</span><a href="' . $url . '" target="'.$target.'"><b>' . $data->title . '</b></a><br />' . $content . '</li>';
			} else {
			echo '<li><a href="' . $url . '" target="'.$target.'"><b>' . $data->title . '</b></a><br />' . $content . '</li>';
		}
	}
	echo '</ul>';
}
function get_pages() {
	$path = GSDATAPAGESPATH;
	$files = getFiles($path);
	$pages = array();
	foreach ($files as $file) {
		if (isFile($file, $path, 'xml')) {
			$pages[] = $path . $file;
		}
	}
	return $pages;
}
/***  Search functions end  ***/

/***  Breadcrumbs function  ***/
function get_parent_link($name, $echo=true) {
	$file = GSDATAPAGESPATH . $name .'.xml';
	if (file_exists($file)) {
		$p = getXML($file);
		$title = $p->menu;
		$parent = $p->parent;
		$url = $p->url;
		if ($echo) {
			echo '<a class="bread-parent" href="'. find_url($name,'') .'">'. $title .'</a>';
		} else {
			return $title;
		}
	}
}

function print_breadcrumbs($name, $current_language="en") {
	if(strpos(strtolower(return_page_slug()), 'index') === false) {
		global $pagesSorted;
		if(!isset($pagesSorted)) return;
		if(count($pagesSorted) < 2) return;
		if(function_exists('return_i18n_available_languages') && count(return_i18n_available_languages()) > 1) {
			$langs_arr=return_i18n_languages();
			$current_language=$langs_arr[0];
			if($current_language != 'en') $home=get_parent_link('index_'.$current_language, false);
			else $home=get_parent_link('index', false);
		}
		else {
			$home=get_parent_link('index', false);
		}
		if($current_language != "en") $name = $name."_".$current_language;
		$page_exist = false;
		foreach($pagesSorted as $page) {
			if($page['url'] == $name) {
				$page_exist = true;
				break;
			}
		} ?> 
		<!-- breadcrumbs: only show when NOT on homepage -->
		<p class="breadcrumbs container center" >
			<span class="wrapper">
				<a class="bread-home" href="<?php get_site_url(); ?>"><?php echo $home; ?></a> <?php
		if(!$page_exist) { 
			echo '</span></p>';
			return;
		}
		$has_parent = $name;
		$parents_val = '';
		while(isset($has_parent) && !empty($has_parent)) {
			foreach($pagesSorted as $page) {
				if($page['url'] == $has_parent) {
					$has_parent = $page['parent'];
					$page_url = $page['url'];
					if(strpos($page_url, '_') !== false) $page_url = substr($page_url, 0, strpos($page_url, '_'));
					if($page['url'] != $name) {
						$parents_val = '<a class="bread-parent" href="'. find_url($page_url,'') .'">'.$page['title'].'</a>'.$parents_val;
					}
				}
			}
		}
		if(!empty($parents_val)) {
			echo $parents_val;
		} ?>
				<span class="bread-current"><?php get_page_clean_title(); ?></span>
		</span></p> <?php
	}
}

/***  i18n Set Language function  ***/
function getDefaultLanguage() {
	if (isset($_SERVER["HTTP_ACCEPT_LANGUAGE"]))
	return parseDefaultLanguage($_SERVER["HTTP_ACCEPT_LANGUAGE"]);
	else return parseDefaultLanguage(NULL);
}
function parseDefaultLanguage($http_accept, $deflang = "en") {
	if(function_exists('return_theme_setting') && return_theme_setting('site_deflang') && strlen(return_theme_setting('site_deflang')) > 1) {
		$deflang = return_theme_setting('site_deflang');
	}
	elseif(isset($http_accept) && strlen($http_accept) > 1)  {
		# Split possible languages into array
		$x = explode(",",$http_accept);
		foreach ($x as $val) {
			#check for q-value and create associative array. No q-value means 1 by rule
			if(preg_match("/(.*);q=([0-1]{0,1}.\d{0,4})/i",$val,$matches))
			$lang[$matches[1]] = (float)$matches[2];
			else
			$lang[$val] = 1.0;
		}
		#return default language (highest q-value)
		$qval = 0.0;
		foreach ($lang as $key => $value) {
			if ($value > $qval) {
				$qval = (float)$value;
				$deflang = $key;
			}
		}
	}
	return $deflang;
}
function check_language($long = true) {
	global $language;
	global $set_lang;
	if(isset($_GET['setlang'])) {
		$langas = $_GET['setlang'];
		if(strlen($langas) == 2) {
			if($langas == "en") $langas = $langas."_US";
			else $langas = $langas."_".strtoupper($langas);
		}
		if (isset($_COOKIE['current_lang'])) { 
			setcookie("current_lang", $langas, time()-100 , '/');
			$_COOKIE['current_lang']=$langas;
		}
		setcookie("current_lang", $langas, time()+3600 , '/');
	}
	if(isset($_COOKIE['current_lang'])) $langas = $_COOKIE['current_lang'];
	elseif(!isset($langas) || empty($langas) || strlen($langas)<2) {
		if(isset($language)) {
			if($long) $langas = $language."_".strtoupper($language);
			else $langas = $language;
		}
		else $langas = getDefaultLanguage();
	}
	if(!isset($langas) || empty($langas) || strlen($langas)<2) {
		if($long) $langas = "en_US";
		else $langas = "en";
	}
	if(strpos($langas, "-") !== false) $langas = str_replace("-", "_", $langas);
	if (file_exists(str_replace('\\','/',dirname(__FILE__)).'/lang/'.$langas.'.php')) {
		include(str_replace('\\','/',dirname(__FILE__)).'/lang/'.$langas.'.php');
	}
	else {
		include(str_replace('\\','/',dirname(__FILE__)).'/lang/en_US.php');
	}
}

/***  Function get GS user e-mail address  ***/
function simple_c_default_email() {
	$files = scandir(GSUSERSPATH);
	foreach ($files as $filename) {
		if (preg_match("#\.xml$#", $filename)) {
			$data = getXML(GSUSERSPATH . $filename);
			return $data->EMAIL;
		}
	}
	return "";
}
?>