<?php if(!defined('IN_GS')){ die('you cannot load this page directly.'); }
/****************************************************
*
* @File: 		template.php
* @Package:		GetSimple
* @Action:		Bridge theme for GetSimple CMS
* @Author Oleg Svetlov http://getsimplecms.ru
*
*****************************************************/
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <title><?php get_page_clean_title(); ?> &lt; <?php get_site_name(); ?></title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
	<!-- fav icons -->
    <link rel="shortcut icon" href="<?php get_site_url(); ?>favicon.ico" type="image/x-icon">	
	<?php get_header(); ?>
    <!-- styles -->
	<link href='http://fonts.googleapis.com/css?family=Playfair+Display:700italic&subset=latin,cyrillic' rel='stylesheet' type='text/css'>
	<link type="text/css" href="<?php get_theme_url(); ?>/style.css" rel="stylesheet">
    <!-- for IE6-8 support of HTML5 elements -->
    <!--[if lt IE 9]>
      <script src="http://html5shim.googlecode.com/svn/trunk/html5.js"></script>
	  <link type="text/css" href="<?php get_theme_url(); ?>/css/ie.css" rel="stylesheet">
    <![endif]-->
</head>

<body id="<?php get_page_slug(); ?>">
<!-- wrapper -->
<section id="wrapper">
    <!-- header -->
    <header id="header">
	    <section class="container">
            <figure id="logo">
			    <div class="padding">
                <a href="<?php get_site_url(); ?>"><img src="<?php get_theme_url(); ?>/images/logo.jpg" alt=""></a>
                <figcaption><?php get_site_name(); ?></figcaption>
				<span><?php get_component('tagline'); ?></span>
				</div>
            </figure>			
			<nav id="nav">
			    <div class="padding">
			    <ul class="menu">
                    <?php get_navigation(return_page_slug()); ?>
                </ul>
                </div>
			</nav>
			<div class="clearfix"></div>
		</section>
    </header>
    <!-- /header -->
	<!-- index-block -->
	<section id="index-block">
		<section class="container">
            <div class="one-col" id="slider">
		        <div class="padding">
				    <img src="<?php get_theme_url(); ?>/images/slider/main.jpg" alt="" />
				</div>				
			</div>
			<div class="clearfix"></div>
		</section>		
	</section>
    <!-- /index-block -->	
	<!-- h1 -->
	<section id="h1">
	    <section class="container">
            <div class="one-col"><div class="padding"><h1><?php get_page_title(); ?></h1></div></div>
			<div class="clearfix"></div>
		</section>	
	</section>
    <!-- /h1 -->	
    <!-- content -->
    <section id="content">
	    <!-- text -->
	    <section class="container">
	        <article class="two-thirds-col">
			    <div class="padding">
		        <?php get_page_content(); ?>
				<p>Published on <time datetime="<?php get_page_date('Y-m-d'); ?>" pubdate><?php get_page_date('F jS, Y'); ?></time></p>
				</div>
		    </article>		
		    <aside class="one-third-col">
		        <div class="padding">
				<?php get_component('sidebar');	?>
				</div>
		    </aside>
			<div class="clearfix"></div>
		</section>
		<!-- /text -->
	</section>
	<!-- /content -->	
    <!-- footer -->
    <footer id="footer">
		<section class="container" id="copy">
			<div class="one-col">
			    <div class="padding">
				    <div class="company">Copyright &copy; <?php echo date('Y'); ?> <a href="<?php get_site_url(); ?>" ><?php get_site_name(); ?></a></div>
					<div id="cms">
						<a href="http://get-simple.info/" target="_blank" title="GetSimple CMS"><img alt="GetSimple CMS" src="<?php get_theme_url(); ?>/images/logo/getsimple20x20.png" /></a> 
						<a href="http://getsimplecms.ru/" target="_blank" title="GetSimple CMS по-русски"><img alt="GetSimple CMS in Russian" src="<?php get_theme_url(); ?>/images/logo/getsimple20x45-ru.png" /></a>
					</div>
				</div>
			</div>
			<div class="clearfix"></div>
		</section>
    </footer>
    <!-- /footer -->
</section>
<!-- /wrapper -->
<?php get_footer(); ?>
</body>
</html>