<?php if(!defined('IN_GS')){ die(''); }
/****************************************************
* @File: 		template.php
* @CMS:			GetSimple
* @Description:	BLUEBUSINESS template for getsimple CMS
* @Author:		Wojciech Jodła - www.wujitsu.pl
*****************************************************/
?>
<!DOCTYPE html>
<html <?php if (function_exists('return_i18n_default_language')) {echo 'lang="'.$language.'"';}?>>
<head>
<meta charset="UTF-8">
<title><?php get_page_clean_title(); ?> - <?php get_site_name(); ?></title>
<script src="https://ajax.googleapis.com/ajax/libs/jquery/1.7.2/jquery.min.js" type="text/javascript"></script>
<?php 
 if (function_exists('return_i18n_setlang_url')){
 switch ($language) {
    case "ru":
		$fface = '<link href="http://fonts.googleapis.com/css?family=Open+Sans+Condensed:700,300&subset=cyrillic-ext" rel="stylesheet" type="text/css">';
        break;
    case "gr":
		$fface = '<link href="http://fonts.googleapis.com/css?family=Open+Sans+Condensed:700,300&subset=greek-ext" rel="stylesheet" type="text/css">';
        break;
	default:
		$fface = '<link href="http://fonts.googleapis.com/css?family=Open+Sans+Condensed:700,300&subset=latin-ext" rel="stylesheet" type="text/css">';
}
	echo $fface;
} 	else echo '<link href="http://fonts.googleapis.com/css?family=Open+Sans+Condensed:700,300&subset=latin-ext" rel="stylesheet" type="text/css">';

	if(function_exists('get_i18n_header')) { get_i18n_header(); } else get_header();?>
<meta name="robots" content="index,follow,noodp"/>
<meta name="author" content="Wojciech Jodła - www.WuJitsu.pl" />
<link rel="icon" type="image/png" href="<?php get_theme_url(); ?>/gfx/favicon.png">
<link rel="stylesheet" type="text/css" href="<?php get_theme_url(); ?>/css/style.min.css" media="screen" />
<script src="<?php get_theme_url(); ?>/js/slimbox2.js" type="text/javascript"></script>
<script type="text/javascript">
$(window).load(function(){
	$("section#sidebar").css("min-height", function(){ return $("section#page-content-container").height()+50 });
});
	</script>
<!--[if lt IE 9]>
<script src="<?php get_theme_url(); ?>/js/html5.js" type="text/javascript"></script>
<![endif]-->
<!--[if lt IE 8]>
<div id="noscript"><strong>Caution</strong>: due to security vulnerabilities of your current version of Internet Explorer, we highly recommend to update your browser to latest version.</div>
<![endif]-->
<!--[if lte IE 9]><style type="text/css">hr#content-bottom-backg {margin-left:1px;}</style><![endif]-->
<!--[if lte IE 7]><style type="text/css">section#sidebar {width:204px;}	hr#static-hr {margin-top:-25px} section#sidebar form.search {margin-top:-42px;}</style><![endif]-->
</head>
<body>
<section id="wrapper">
<header id="topheader">
	<figure id="header-frame">
		<img src="<?php get_theme_url(); ?>/gfx/header-frame.png">
	</figure>
	<figure id="sitename">
		<?php get_site_name(); ?>
	</figure>
	<?php if (function_exists('return_i18n_setlang_url') && componentexist('sitelanguage')) { ?>
		<section id="sitelanguage">
		<ul>
			<?php get_component('sitelanguage'); ?>
		</ul>
		</section>
	<?php } ?>
	<figure id="logo">
		<a href="<?php get_site_url(); ?>" title="homepage">
			<img src="<?php get_site_url(); ?>/data/uploads/logo.png" alt="Logo">
		</a>
	</figure>
	<nav id="site-navigation">
		<ul>
			<?php 
			if (function_exists('get_i18n_navigation')) { 
				get_i18n_navigation(return_page_slug(),0,2,I18N_SHOW_MENU|I18N_FILTER_LANGUAGE);
			} else get_navigation(return_page_slug()); 
			?>
		</ul>
	</nav>
</header>
	<hr id="content-top-backg">
	<section id="sidebar">
			<?php if (function_exists('get_i18n_search_form')) { 
					get_i18n_search_form(array('slug'=>'search','showTags'=>0,'ajax'=>0));
				} ?>
			<?php if (function_exists('get_i18n_component') && componentexist('sidebar')) {
					get_i18n_component('sidebar');
				} elseif (componentexist('sidebar')) {
					get_component('sidebar');
				}
			?>
	</section>
	<section id="page-content-container">
	
		<article id="page-content">
			<?php
			if(return_page_slug() != "search") {
				echo '<h1 id="pagetitle">'.return_page_title().'</h1>';
			}
				get_page_content(); 
			?>
			
		</article>
<?php
	if (function_exists('return_i18n_default_language')) { 
		if ($language == return_i18n_default_language()) {
			$introbox_lang = '';
		} else $introbox_lang = '_'.$language;
	} else $introbox_lang = '';

	$introbox1_path = @implode("/",glob(GSDATAPAGESPATH.'indexbox1'.$introbox_lang.'.xml'));
	$introbox2_path = @implode("/",glob(GSDATAPAGESPATH.'indexbox2'.$introbox_lang.'.xml'));	
	if (file_exists($introbox1_path) && function_exists('get_i18n_content') && return_page_slug() == "index") {
		echo '<article class="introbox"><h2>'.
				load_page_title("indexbox1$introbox_lang").'</h2>';
				get_i18n_content('indexbox1');
		echo '</article>';
	}else {
		$introbox1 = load_box_content('indexbox1');
		if (!empty($introbox1) && return_page_slug() == "index") { 
		echo '<article class="introbox">'.
			$introbox1.
			'</article>';
		}
	}
/*  BLUEBUSINESS template for getsimple CMS
    Author: Wojciech Jodła - www.wujitsu.pl  */	
	if (file_exists($introbox2_path) && function_exists('get_i18n_content') && return_page_slug() == "index") {
		echo '<article class="introbox"><h2>'.
				load_page_title("indexbox2$introbox_lang").'</h2>';
				get_i18n_content('indexbox2');
		echo '</article>';
	}else {
		$introbox2 = load_box_content('indexbox2');
		if (!empty($introbox1) && return_page_slug() == "index") { 
		echo '<article class="introbox">'.
			$introbox2.
			'</article>';
		}
	}
	?>
			<section id="static"><strong>
				<!-- show static content! -->
				<?php showstatic(); ?>
			</strong></section>
			<hr id="static-hr">		
	</section>
	<hr id="content-bottom-backg">
	<footer>
		<section id="copyrights">
			<?php 
			echo '&copy;'.' '.get_site_name(FALSE) . ' ' ;
			if (function_exists('get_i18n_component') && componentexist('copyrights')) {
					get_i18n_component('copyrights');
				} elseif (componentexist('copyrights')) {
					get_component('copyrights');
				}
			?>
		</section>
		<!-- link to author's website, see license -->
		<section id="creation">
			<a href="http://getsimple.wujitsu.pl/bluebusiness/">BlueBusiness theme</a> - <a class="webdesigner" title="WuJitsu.pl - art of promotion in the wwweb" href="http://www.wujitsu.pl">WuJitsu.pl</a>
			<p class="poweredby"><?php get_site_credits();?></p>
		</section>
	</footer>
</section>
<noscript>
	<div id="noscript"><strong>Caution</strong>: 
		The page you are trying to access requires JavaScript in order to work properly. Please enable Javascript in your browser, and refresh the page.
	</div>
</noscript>
</body>
</html>